<?php
require 'php/simple_html_dom.php';
/**
 * error reporting
 */
//ini_set('display_errors',1);
//ini_set('display_startup_errors',1);
//error_reporting(-1);

/**
 * general settings
 */
/**
 * general config
 */
$site['api_key'] = 'a13aad289d352c775a15f3171572e9dd';
$site['api_url'] = 'http://splashcake.com/cake/api.php';
$url_base = $site['api_url'] . '?api_key=' . $site['api_key'];

switch (basename($_SERVER['PHP_SELF'])) {
    case 'news-view.php':
    case 'news.php':
        if (basename($_SERVER['PHP_SELF']) == 'news-view.php') {
            $articles = widget_recent_articles($url_base, 0);
        } else {
            $articles = '';
            $articles = widget_recent_articles($url_base, 0);
        }
        $searchbox = true;
        $sidebar = ''
                . '<div class="vc_span4 wpb_column column_container">'
                . $articles
                . '<div class="wpb_wrapper">'
                . '<div class="homebox full-width homebox-list">'
                . '<div class="homeboxTitle"><h3>Search & Keyword Tags</h3></div>'
                . '<div class="homeboxExerpt">
                        
                        <form id="search" action="news.php" method="get" class="search">
                            <fieldset class="search-fieldset">                        
                                <input type="text" name="tag" id="tag" placeholder="Type your query and click search" class="search_input" />
                                <button type="submit" value="Submit">Submit</button>
                            </fieldset>
                           
                        </form>
                        <br /><br />
                        <h3>Click on our most popular Keyword Tags</h3>'
                . get_news_tags($url_base)
                . '</div>'
                . '</div>'
                . '</div>'
                . '</div>';
        break;
    case 'health.php':
        $sidebar = ''
            . '<div class="vc_span4 wpb_column column_container">'
            . '<div class="wpb_wrapper">'
            . widget_knowledge_base($url_base)
            . widget_calculators(1)
            . '</div>'
            . '</div>';
        break;
    case 'ask-your-pharmacist.php':
        $sidebar = ''
                . '<div class="vc_span4 wpb_column column_container page_margin_top">
				<div class="wpb_wrapper">
					<div class="homebox full-width">
						<div class="homeboxTitle"><h3>5 point plan to deliver better health service for customers</h3></div>
						<br />
						<div class="homeboxExerpt underline">
							<h3>Open Door Policy</h3>
							<p>Increased access for patients to healthcare by utilising pharmacists earlier in the health life cycle of the patient.</p>
						</div>
						<div class="homeboxExerpt underline">
							<h3>Access to Chronic Disease Management</h3>
							<p>Patients to have access to professional assessment through pharmacies by monitoring of potential symptoms and identification of pre-disposure to certain illnesses.</p>
						</div>
						<div class="homeboxExerpt underline">
							<h3>Provision of Vaccination Service</h3>
							<p>Patients to have the choice to receive vaccines such as the flu vaccine through their local pharmacy.</p>
						</div>
						<div class="homeboxExerpt underline">
							<h3>Medicines Management</h3>
							<p>Patients to have access to a strategic, ongoing medicines management regime where pharmacists check for drug overlaps and monitor supply of medications provided to patient through Government Schemes.</p>
						</div>
						<div class="homeboxExerpt">
							<h3>Health Promotion</h3>
							<p>Patients to benefit from health promotion services through pharmacies including smoking cessation, weight management and diabetic and cholesterol screening to help create a healthier society overall.</p>
						</div>
					</div>
				</div>
			</div>';
        break;
    default:
        $sidebar = ''
                . '<div class="vc_span4 wpb_column column_container">
				<div class="wpb_wrapper">'
                . widget_knowledge_base($url_base)
                . widget_special_offers($url_base)
                . '
				</div>
			</div>';
        break;
}

// fetcher functions to communicate with the api
/**
 * get the data from the api
 * this simply takes the url base to create the url to connect to and the set
 * of parameters that need to be sent to the api to determine what to send back
 *
 * @param string $url_base
 * @param array $params
 * @return array
 */
function get_data($url_base, $params) {
    $str = '';
    foreach ($params as $k => $v) {
        $str .= "&$k=$v";
    }
    $url = $url_base . $str;
    //echo $url;
    $r = file_get_contents($url);
    $array = unserialize($r);
    return $array;
}

function get_news_tags($url_base, $basic = false) {
    $url = $url_base . '&action=news-tags';
    $r = file_get_contents($url);
    $array = unserialize($r);
    $tags = array();
    foreach ($array as $one) {
        $tmp = explode(',', $one['tags']);
        $tags = array_merge($tags, $tmp);
    }
    // remove blanks
    $tmp = array();
    foreach ($tags as $k => $v) {
        if (trim($v) != '') {
            $temp[] = trim($v);
        }
    }
    // get a count for the tag occurrence
    $tags = array_count_values($temp);
    arsort($tags);
    $i = 1;
    $max_tags = 18;
    $html = '';
    foreach ($tags as $k => $v) {
        if ($i <= $max_tags) {
            $html .= '<a href="news.php?tag=' . $k . '" class="blue link-button tag button small green">' . $k . '</a>';
        }
        $i++;
    }
    if ($html) {
        $html .= '<br /><br />';
    }
    if ($basic) {
        return $tags;
    } else {
        return $html;
    }
}

/**
 * general functions
 */
function snippet($string, $start = 0, $length = 300) {
    $string = strip_tags($string);
    return substr($string, $start, $length) . '... ';
}

function time2date($time, $format = 'd/m/Y') {
    return date($format, $time);
}

function format_date($date) {
    return date('l jS F Y', strtotime(str_replace('/', '-', $date)));
}

function fix_url($url) {
    $t = parse_url($url);
    if (!isset($t['scheme'])) {
        $url = "http://" . $url;
    }
    return $url;
}

function paginate_array($array, $per_page = 2) {
    return array_chunk($array, $per_page);
}

function clean_content($content) {
	return strip_tags($content, '<h1><h2><h3><h4><h5><h6><p><ol><ul><li>');
}

function create_accordion($string) {
	$string = strip_tags($string, '<h1><h2><h3><h4><h5><h6><p><ol><ul><li>');
	$string = trim($string);
	$ret = str_replace('</h3>', '</h3><div>', $string);
	$ret = str_replace('<h3', '</div><h3', $ret);
	$ret .= '</div>';
	$ret = substr($ret, 6);
	return $ret;
}

function a_z_links() {
	$html = '';
	for ($i=65; $i<=90; $i++) {
		$html .= '<li' . $cls . '><a href="health.php?a=' . chr($i) . '" class="btn btn-primary btn-xs ' . $class . '">' . chr($i) . '</a></li>';
	}
    $html = '<ul class="a-z widget">'
			. $html
			. '</ul>';
	return $html;
}

function international_telephone($phone, $country_code = '+353') {
    if (stristr($phone,'+353')) {
        $ret = $phone;
    } else {
        $ret = $country_code . ' ' . ltrim($phone, '0');
    }
    return $ret;
}

function list_tools($data) {
	$html = '';
	foreach ($data as $k => $v) {
		$html .= ''
			. '<br /><br /><div class="color-strip no-padding"><img src="img/bg-color-strip.png" /></div>'
			. '<div class="wrapper-tool">'
			. '<h3>' . $v['title'] . '</h3>'
			. '<p>' . $v['description'] . '</p>'
			. '<p class="tool-code">' . strip_tags($v['code'], '<object><param>') . '</p>'
			. '</div>';
	}
	return $html;
}

function opt_days($current_day='Monday') {
	$html = '';
	$days = array('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday');
	$today = date('l');
	$tomorrow = date('l', strtotime('+1 day'));
	foreach ($days as $day) {
		if (strtolower($day) != strtolower($today)) {
			($day == $tomorrow) ? $s = ' selected="selected"' : $s = '' ;
			$html .= '<option value="' . $day . '"' . $s . '>' . $day . '</option>';
		}
	}
	return $html;
}

function opt_times($current_time='Afternoon') {
	$html = '';
	$times = array('Morning','Afternoon','Evening');
	foreach ($times as $time) {
		($current_time == $time) ? $s = ' selected="selected"' : $s = '' ;
		$html .= '<option value="' . $time . '"' . $s . '>' . $time . '</option>';
	}
	return $html;
}

/**
 * widgets
 */
function widget_recent_articles($url_base, $type = 0) {
    $html = '';
    $array = get_data($url_base, array('action' => 'news', 'status' => 1));
    $i = 1;
    $max = 5;
    foreach ($array as $one) {
        if ($i <= $max) {
            $html .= ''
                    . '<li><a href="news-view.php?news_id=' . $one['news_id'] . '">' . $one['title'] . '</a></li>';
        }
        $i++;
    }
    if ($html) {
        $html = ''
                . '<div class="wpb_wrapper">'
                . '<div class="homebox full-width homebox-list">'
                . '<div class="homeboxTitle"><h3>Recent News Articles</h3></div>'
                . '<ul class="sidebar-list">'
                . $html
                . '<li><a href="news.php">View All News Articles</a></li>'
                . '</ul>'
                . '</div>'
                . '</div>';
    }
    return $html;
}

function widget_health_sidebar($url_base) {
	$html = '';
	$data = get_data($url_base, array('action' => 'page_type', 'page_type' => 'health-knowledge-base'));
	foreach ($data as $k => $v) {
		$html .= '<li><a href="page.php?page_id=' . $v['page_id'] . '">' . $v['title'] . '</a></li>';
	}
	if ($html) {
		$html = ''
				. '<div class="homebox full-width homebox-list">
						<ul class="simple plus">
						' . $html . '
						</ul>
					</div>';
	}
	return $html;
}

function widget_knowledge_base($url_base, $menu=0) {
	if ($menu) {
		$html = ''
				. '<li class="menu-item"><a href="beauty.php">Beauty Tips</a></li>'
				. '<li class="menu-item"><a href="recipes.php">Recipes</a></li>'
				. '<li class="menu-item"><a href="health.php">Health A-Z</a></li>'
				. '<li class="menu-item"><a href="articles.php">Healthy Living</a></li>'
				. '<li class="menu-item"><a href="tools.php">Healthcare Tools/Media</a></li>'
				. '<li class="menu-item"><a href="ask-your-pharmacist.php">Ask your Pharmacist</a></li>'
				. '<li class="menu-item"><a href="downloads.php">Healthcare Information Leaflets</a></li>'
				. '<li class="menu-item"><a href="links.php">Healthcare Links</a></li>'
				. '<li class="menu-item"><a href="health-calculators.php">Healthcare Calculators</a></li>';
	} else {
		$html = '<div class="homebox full-width homebox-list">'
				. '<div class="homeboxTitle"><h3>Health Insight</h3></div>'
				. '<ul class="simple plus">'
				. '<li><a href="beauty.php">Beauty Tips</a></li>'
				. '<li><a href="recipes.php">Recipes</a></li>'
				. '<li><a href="health.php">Health A-Z</a></li>'
				. '<li><a href="articles.php">Healthy Living</a></li>'
				. '<li><a href="tools.php">Healthcare Tools/Media</a></li>'
				. '<li><a href="ask-your-pharmacist.php">Ask your Pharmacist</a></li>'
				. '<li><a href="downloads.php">Healthcare Information Leaflets</a></li>'
				. '<li><a href="links.php">Healthcare Links</a></li>'
				. '<li><a href="health-calculators.php">Healthcare Calculators</a></li>'
				. '</ul>'
				. '</div>';
	}
    return $html;
}

function widget_calculators($fullwidth=0) {
    ($fullwidth) ? $cls=' full-width' : $cls='' ;
    $html = '<div class="homebox ' . $cls . '">'
            . '<div class="homeboxImage"><a href="health-calculators.php"><img src="/cake-client/calculators/img/homebox.jpg" alt="" /></a></div>'
            . '<div class="homeboxTitle"><h3>Health Calculators</h3></div>'
            . '<div class="homeboxExerpt"><p>Our online health calculators are designed to help you calculate everything related to fitness, nutrition, working out, counting calories, and more! - <a href="health-calculators.php" class="read-more">Click here for Calculators</a></p></div>'
            . '</div>';
    return $html;
}

function widget_special_offers($url_base) {
    $html = '';
    $data = get_data($url_base, array('action' => 'offers', 'status' => 1));
    $key = array_rand($data);
    $data = $data[$key];

    $html = '<div class="homebox full-width">'
            . '<div class="homeboxTitle"><h3>Special Offers</h3></div>'
            . '<div class="homeboxExerpt">'
            . '<p>Join our mailing list to keep up to date with our in-store Special Offers! - <a href="offers.php" class="read-more">Click Here</a></p>'
            . '</div>'
            . '<div class="homeboxImage">'
            . '<a href="offer-view.php?offer_id=' . $data['offer_id'] . '">'
            . '<div class="widget-ribbon">'
            . '<div><span class="text-one">' . $data['ribbon_text_1'] . '</span><br /><span class="text-two">' . $data['ribbon_text_2'] . '</span></div>'
            . '</div>'
            . '<img src="' . $data['offer_image'] . '">'
            . '</a>'
            . '</div>'
            . '</div>';
    return $html;
}

/**
 * show_page_sidebar
 *
 * show the relevant sidebar for a page
 *
 * use the page_id to determine if it is a parent or child
 * if it's a parent simply get all sub pages
 * if it's a child get the sub pages of it's parent
 * simples!
 *
 * @param int $page_id
 * @return string $html
 */
function show_page_sidebar($url_base, $page_id=0) {
    $data = get_data($url_base, array('action' => 'page', 'page_id' => $page_id));
    $data = $data[0];
    //debug($data);
    if ($data['parent'] == 0) {
        $sub_pages = get_data($url_base, array('action'=>'sub-pages','page_id'=>$page_id));
        $title = $data['title'];
    } else {
        $sub_pages = get_data($url_base, array('action'=>'sub-pages','page_id'=>$data['parent']));
        $tmp = get_data($url_base, array('action' => 'page', 'page_id' => $data['parent']));
        $title = $tmp['0']['title'];
    }
    //debug($sub_pages);
    $html = '';
    foreach ($sub_pages as $k => $v) {
        $html .= '
        <li><a href="page.php?page_id=' . $v['page_id'] . '">' . $v['title'] . '</a></li>';

    }
    if ($html) {
        $html = '
        <aside>
            <h3>'.$title.'</h3>
            <ul class="sidebar-list">
                '.$html.'
            </ul>
        </aside>
        ';
    }
    echo $html;
    return $html;
}

/**
 * debug
 *
 * handy debug function
 *
 * @param object $o
 * @param boolean $is
 * @return string
 */
function debug($o = null, $is = false) {
    $s = "<pre>" . print_r($o, true) . "</pre><br/>";
    if ($is) {
        return $s;
    } else {
        echo $s;
    }
}